@extends('layouts.master')

@section('title')
    Absensi {{$staff->name}}
@endsection

@section('breadcrumb')
    @parent
    <li class="active">Absensi</li>
@endsection
<link rel="stylesheet" href="{{asset('css/buttons.dataTables.min.css')}}">
@section('content')
<div class="row">
    <div class="col-lg-6">
        <div class="box">
             <div class="box-header with-border">
                {{-- <div class="box-header with-border">
                 <div class="row">
                      <div class="col-lg-6">
                        <input type = "text" name="from_date" id="from_date" class="form-control" placeholder="From Date" readonly/>
                      </div>
                      <div class="col-lg-6">
                        <input type = "text" name="to_date" id="to_date" class="form-control" placeholder="To Date" readonly/>
                 </div>
                 
                 <div class="row" style="margin-top:53px;">
                     <div class="col-lg-2" style="padding-left: 30px;">
                        <button type="button" name="filter" id="filter" class="btn btn-primary">Filter</button>
                     </div>
                      <div class="col-lg-3">
                        <button type="button" name="refresh" id="refresh" class="btn btn-primary">Refresh</button>
                      </div>
                 </div> --}}
                    <h4>Check in</h4>
                </div>
                <div class="box-body table-responsive">
                <table class="table table-stiped table-bordered table-penjualan" id="table1">
                    <thead>
                         <th style="width: 5%;">No</th>
                        <th>Tanggal/Waktu</th>    
                        <th>Nama Member</th>    
                    </thead>
                </table>   
            </div>
        </div>
    </div>
      <div class="col-lg-6">
        <div class="box">
            <div class="box-header with-border">
                <h4>Check Out</h4>
            </div>
            
            <div class="box-body table-responsive">
                {{-- <form action="" method="post" class="form-produk"> --}}
                    {{-- @csrf --}}
                    <table class="table table-stiped table-bordered" id="table2">
                        <thead>
                            <th style="width: 5%;">No</th>
                            <th>Tanggal</th>
                            <th>Nama Member</th>
                        </thead>
                    </table>
                </form>
            </div>
        </div>
    </div>
</div>

@includeIf('absen.form')
@endsection
@push('scripts')
<script src="{{ asset('/AdminLTE-2/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js') }}"></script>





<script>
$(document).ready(function(){
    $('.input-daterange').datepicker({
        todayBtn:'linked',
        format:'yyyy-mm-dd',
        autoclose:true
    });

    load_data();
    function load_data(from_date = '', to_date = '')
    {
        table1 = $('#table1').DataTable({
            responsive: true,
            processing: true,
            serverSide: true,
            autoWidth: false,
            searching: true,
            dom: 'lBfrtip',
            buttons: ['excel', 'pdf', 'print'],
            ajax: {
                url: '{{ route('staff.data_absen', $staff->id) }}',
            },

            columns: [
                {data: 'DT_RowIndex', searchable: false, sortable: false},
                // {data: 'visit'},              
                {data: 'waktu'},             
                {data: 'nama_member'},             
            ],
        });
    }

    $('#filter').click(function(){
        var from_date = $('#from_date').val();
        var to_date = $('#to_date').val();
        console.log(from_date ,to_date)
         if(from_date != '' && to_date != '')
         {
            $('#table1').DataTable().destroy();
            load_data(from_date, to_date);
         }
         else
         {
            alert('Both Date is required bitch!!!!')
         }
    });
    $('#refresh').click(function(){
        $('#from_date').val('');
        $('#to_date').val('');
        $('#table1').DataTable().destroy();
        load_data();
    });
});
</script>
<script>
   

    $(function () {
        table2 = $('#table2').DataTable({
            responsive: true,
            processing: true,
            serverSide: true,
            autoWidth: false,
            searching: true,
             dom: 'lBfrtip',
            buttons: ['excel', 'pdf', 'print'],
            ajax: {
                url: '{{ route('staff.out',$staff->id) }}',
            },
            columns: [
                {data: 'DT_RowIndex', searchable: false, sortable: false},
                // {data: 'visit'},              
                {data: 'waktu'}, 
                {data: 'nama_member'},               
            ]

            
    });
     
        

        

        $('#modal-form2').validator().on('submit', function (e) {
            if (! e.preventDefault()) {
                $.post($('#modal-form2 form').attr('action'), $('#modal-form2 form').serialize())
                    .done((response) => {
                        $('#modal-form2').modal('hide');
                        table2.ajax.reload();
                    })
                    .fail((errors) => {
                        alert('Tidak dapat menyimpan data');
                        return;
                    });
            }
        });
       

        $('[name=select_all]').on('click', function () {
            $(':checkbox').prop('checked', this.checked);
        });
    });

    function addForm2(url) {
        $('#modal-form2').modal('show');
        $('#modal-form2 .modal-title').text('Tambah Visit Personal');

        $('#modal-form2 form')[0].reset();
        $('#modal-form2 form').attr('action', url);
        $('#modal-form2 [name=_method]').val('post');
        $('#modal-form2 [name=nama]').focus();
    }

    

  

    
    
</script>
@endpush