@extends('layouts.master')

@section('title')
    Absen {{$member->nama}}
@endsection

@section('breadcrumb')
    @parent
    <li class="active">Check in Member</li>
@endsection

@section('content')
<div class="row">
    <div class="col-lg-12">
        <div class="box">
             <div class="box-header with-border">
                <h4>Check in</h4>
            </div>
            <div class="box-body table-responsive">
                <table class="table table-stiped table-bordered table-penjualan" id="table1">
                    <thead>
                        <th>No</th>    
                        <th>Tanggal/Waktu</th>    
                        <th>Personal Trainer</th>    
                    </thead>
                </table>   
            </div>
        </div>
    </div>
     
</div>


@endsection
@push('scripts')
<script>
     $(function () {
        table1 = $('#table1').DataTable({
            responsive: true,
            processing: true,
            serverSide: true,
            autoWidth: false,
            searching: true,
             dom: 'lBfrtip',
            buttons: ['excel', 'pdf', 'print'],
            ajax: {
                url: '{{ route('member.data_absen',$member->id_member) }}',
            },
            columns: [
                {data: 'DT_RowIndex', searchable: false, sortable: false},
                // {data: 'visit'},              
                {data: 'waktu'},             
                {data: 'nama_pt'},             
            ]
        });

        

        

        $('#modal-form').validator().on('submit', function (e) {
            if (! e.preventDefault()) {
                $.post($('#modal-form form').attr('action'), $('#modal-form form').serialize())
                    .done((response) => {
                        $('#modal-form').modal('hide');
                        table1.ajax.reload();
                    })
                    .fail((errors) => {
                        alert('Tidak dapat menyimpan data');
                        return;
                    });
            }
        });
       

        $('[name=select_all]').on('click', function () {
            $(':checkbox').prop('checked', this.checked);
        });
    });
</script>

@endpush