<?php

namespace App\Http\Controllers;

use App\Models\Pembelian;
use App\Models\PembelianGym;
use App\Models\Pengeluaran;
use App\Models\Penjualan;
use App\Models\Member;
use App\Models\Produk;
use App\Models\TotalKeseluruhan;
use App\Models\PenjualanDetail;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use PDF;

class LaporanAuthController extends Controller
{
    public function index2(Request $request)
    {

        $auth = auth()->user()->name;
        $auth2 = auth()->user()->id;
        $date =  date('Y-m-d');
        $today = Carbon::today()->toDateString();
        // dd($time);
  
        // level kasir
            $total_member = TotalKeseluruhan::where('role',$auth)->where('created_at', '>=', Carbon::today())->sum('total');
            $total = DB::table('total_keseluruhan')
            ->join('member', 'member.id_member', '=', 'total_keseluruhan.id_member')
            ->select('member.*','total_keseluruhan.id','total_keseluruhan.status')
            ->where('total_keseluruhan.role',$auth)
            ->where('total_keseluruhan.created_at', '>=',Carbon::today())
            ->groupBy('id')
            ->get();
        //    dd($total);
        // end level

        // level admin
            $total_member_untuk_admin = TotalKeseluruhan::where('created_at', '>=', Carbon::today())->sum('total');
            $total_untuk_admin = DB::table('total_keseluruhan')
            ->join('member', 'member.id_member', '=', 'total_keseluruhan.id_member')
            ->select('member.*','total_keseluruhan.id','total_keseluruhan.role','total_keseluruhan.status','total_keseluruhan.total')
            ->where('total_keseluruhan.created_at', '>=',Carbon::today())
            ->groupBy('id')
            ->get();  
            //  dd($total_untuk_admin);   
        // end level


       
    // kasir
        $food = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
             ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',2)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $drink = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')

             ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',3)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $suplement = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',4)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $protein = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',5)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $coffee = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',6)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $akses = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',7)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $fitness = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',8)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $total_food = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',2)
            ->sum('subtotal');

        $total_drink = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',3)
            ->sum('subtotal');

        $total_suplement = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',4)
            ->sum('subtotal');

        $total_protein = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',5)
            ->sum('subtotal');

        $total_coffee = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',6)
            ->sum('subtotal');

        $total_akses = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',7)
            ->sum('subtotal');


        $total_fitness = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',8)
            ->sum('subtotal');
        
        $item = PembelianGym::where('id_user',$auth2)->where('created_at', '>=', Carbon::today())->get();
        $total_metune = PembelianGym::where('id_user',$auth2)->where('created_at', '>=', Carbon::today())->sum('total');
        
        
        // end kasir


         // admin
        $food_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',2)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $drink_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',3)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $suplement_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',4)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $protein_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',5)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $coffee_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',6)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $akses_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',7)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $fitness_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',8)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $total_food_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',2)
            ->sum('subtotal');

        $total_drink_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',3)
            ->sum('subtotal');

        $total_suplement_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',4)
            ->sum('subtotal');

        $total_protein_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',5)
            ->sum('subtotal');

        $total_coffee_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',6)
            ->sum('subtotal');

        $total_akses_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',7)
            ->sum('subtotal');


        $total_fitness_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',8)
            ->sum('subtotal');
        
        $item_admin = PembelianGym::where('created_at', '>=', Carbon::today())->get();
        $total_metune_admin = PembelianGym::where('created_at', '>=', Carbon::today())->sum('total');
        // end admin
       
       
        $tanggalAwal = date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
        $tanggalAkhir = date('Y-m-d');

        if ($request->has('tanggal_awal') && $request->tanggal_awal != "" && $request->has('tanggal_akhir') && $request->tanggal_akhir) {
        $tanggalAwal = $request->tanggal_awal;
        $tanggalAkhir = $request->tanggal_akhir;
        }

        return view('shift.index', compact( 'total_metune_admin','item_admin','suplement_admin','protein_admin','coffee_admin','akses_admin','fitness_admin','total_food_admin','total_drink_admin','total_suplement_admin','total_protein_admin','total_coffee_admin','total_akses_admin','total_fitness_admin','drink_admin','food_admin','total_member_untuk_admin','total_untuk_admin','total_fitness','fitness','total_akses','akses','coffee','total_coffee','protein','total_protein','total_suplement','suplement','total_drink','drink','total_food','total_member','tanggalAwal', 'tanggalAkhir','date','auth','total','food','item','total_metune'));
    }

    public function getData2($awal, $akhir)
    {


    }

    public function hapus($id)
{
	// menghapus data pegawai berdasarkan id yang dipilih
        $total = TotalKeseluruhan::find($id);
        $total->delete();
        return redirect()->route('shift.index')->with('hapus', 'Data Berhasil Dihapus');;
}

    public function data($awal, $akhir)
    {
        $data = $this->getData($awal, $akhir);

        return datatables()
            ->of($data)
            ->make(true);
    }

    public function exportPDF2($awal, $akhir)
    {
        $data = $this->getData($awal, $akhir);
        $pdf  = PDF::loadView('laporan.pdf', compact('awal', 'akhir', 'data'));
        $pdf->setPaper('a4', 'potrait');
        
        return $pdf->stream('Laporan-pendapatan-'. date('d-m-Y-his') .'.pdf');
    }

     public function cetak2(Request $request)
    {
        
       $auth = auth()->user()->name;
       $auth2 = auth()->user()->id;
        $date =  date('Y-m-d');
        $today = Carbon::today()->toDateString();
       
         
          // level kasir
            $total_member = TotalKeseluruhan::where('role',$auth)->where('created_at', '>=', Carbon::today())->sum('total');
            $total = DB::table('total_keseluruhan')
            ->join('member', 'member.id_member', '=', 'total_keseluruhan.id_member')
            ->select('member.*','total_keseluruhan.id','total_keseluruhan.status')
            ->where('total_keseluruhan.role',$auth)
            ->where('total_keseluruhan.created_at', '>=',Carbon::today())
            ->groupBy('id')
            ->get();
        //    dd($total);
        // end level

        // level admin
            $total_member_untuk_admin = TotalKeseluruhan::where('created_at', '>=', Carbon::today())->sum('total');
            $total_untuk_admin = DB::table('total_keseluruhan')
            ->join('member', 'member.id_member', '=', 'total_keseluruhan.id_member')
            ->select('member.*','total_keseluruhan.id','total_keseluruhan.role','total_keseluruhan.status')
            ->where('total_keseluruhan.created_at', '>=',Carbon::today())
            ->groupBy('id')
            ->get();  
            //  dd($total_untuk_admin);   
        // end level


       
    // kasir
        $food = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
             ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',2)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $drink = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')

             ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',3)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $suplement = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',4)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $protein = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',5)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $coffee = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',6)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $akses = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',7)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $fitness = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',8)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $total_food = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',2)
            ->sum('subtotal');

        $total_drink = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',3)
            ->sum('subtotal');

        $total_suplement = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',4)
            ->sum('subtotal');

        $total_protein = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',5)
            ->sum('subtotal');

        $total_coffee = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',6)
            ->sum('subtotal');

        $total_akses = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',7)
            ->sum('subtotal');


        $total_fitness = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',8)
            ->sum('subtotal');
        // end kasir


         // admin
        $food_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',2)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $drink_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',3)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $suplement_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',4)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $protein_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',5)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $coffee_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',6)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $akses_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',7)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $fitness_admin = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',8)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $total_food_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',2)
            ->sum('subtotal');

        $total_drink_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',3)
            ->sum('subtotal');

        $total_suplement_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',4)
            ->sum('subtotal');

        $total_protein_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',5)
            ->sum('subtotal');

        $total_coffee_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',6)
            ->sum('subtotal');

        $total_akses_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',7)
            ->sum('subtotal');


        $total_fitness_admin = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            // ->where('penjualan_detail.id_kategori',8)
            ->sum('subtotal');
        
        $item_admin = PembelianGym::where('created_at', '>=', Carbon::today())->get();
        $total_metune_admin = PembelianGym::where('created_at', '>=', Carbon::today())->sum('total');
        // end admin

            
            $item_admin = PembelianGym::where('created_at', '>=', Carbon::today())->get();
            $total_metune_admin = PembelianGym::where('created_at', '>=', Carbon::today())->sum('total');
            $item = PembelianGym::where('id_user',$auth2)->where('created_at', '>=', Carbon::today())->get();
            $total_metune = PembelianGym::where('id_user',$auth2)->where('created_at', '>=', Carbon::today())->sum('total');
            // dd($total_metune);
            // dd($item);
        $tanggalAwal = date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
        $tanggalAkhir = date('Y-m-d');

        if ($request->has('tanggal_awal') && $request->tanggal_awal != "" && $request->has('tanggal_akhir') && $request->tanggal_akhir) {
            $tanggalAwal = $request->tanggal_awal;
            $tanggalAkhir = $request->tanggal_akhir;
        }
        return view('shift.cetak2',compact('total_metune_admin','item_admin','suplement_admin','protein_admin','coffee_admin','akses_admin','fitness_admin','total_food_admin','total_drink_admin','total_suplement_admin','total_protein_admin','total_coffee_admin','total_akses_admin','total_fitness_admin','drink_admin','food_admin','total_member_untuk_admin','total_untuk_admin','total_fitness','fitness','total_akses','akses','coffee','total_coffee','protein','total_protein','total_suplement','suplement','total_drink','drink','total_food','total_member','tanggalAwal', 'tanggalAkhir','date','auth','total','food','item','total_metune'));
    }

     public function cetak3(Request $request)
    {
        
       $auth = auth()->id();
        $date =  date('Y-m-d');
        $today = Carbon::today()->toDateString();
       
          $pendaftaran = DB::table('member')
            ->join('total_keseluruhan', 'total_keseluruhan.id_member', '=', 'member.id_member')
            ->select('total_keseluruhan.*', 'total_keseluruhan.total','nama')
            ->where('member.created_at', '>=', Carbon::today())
            ->where('member.role',$auth)
            ->get();

            $total_member = TotalKeseluruhan::where('role',$auth)->where('created_at', '>=', Carbon::today())->sum('total');
            $total = DB::table('total_keseluruhan')
            ->join('member', 'member.id_member', '=', 'total_keseluruhan.id_member')
            ->select('member.*')
            ->where('total_keseluruhan.role',$auth)
            ->where('total_keseluruhan.created_at', '>=',Carbon::today())
            ->groupBy('id')
            ->get();
    $total_member_untuk_admin = TotalKeseluruhan::where('created_at', '>=', Carbon::today())->sum('total');
            $total_untuk_admin = DB::table('total_keseluruhan')
            ->join('member', 'member.id_member', '=', 'total_keseluruhan.id_member')
            ->select('member.*','total_keseluruhan.id','total_keseluruhan.role','total_keseluruhan.status')
            ->where('total_keseluruhan.created_at', '>=',Carbon::today())
            ->groupBy('id')
            ->get(); 

      $food = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
             ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',2)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $drink = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')

             ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',3)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $suplement = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',4)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $protein = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',5)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $coffee = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',6)
            ->groupBy('penjualan_detail.id_produk')
            ->get();

        $akses = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',7)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $fitness = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',8)
            ->groupBy('penjualan_detail.id_produk')
            ->get();


        $total_food = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',2)
            ->sum('subtotal');

        $total_drink = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',3)
            ->sum('subtotal');

        $total_suplement = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',4)
            ->sum('subtotal');

        $total_protein = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',5)
            ->sum('subtotal');

        $total_coffee = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',6)
            ->sum('subtotal');

        $total_akses = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',7)
            ->sum('subtotal');


        $total_fitness = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            // ->where('penjualan_detail.id_kategori',8)
            ->sum('subtotal');

            
            // dd ($p);
            $item = PembelianGym::where('id_user',$auth)->where('created_at', '>=', Carbon::today())->get();
            $total_metune = PembelianGym::where('id_user',$auth)->where('created_at', '>=', Carbon::today())->sum('total');
            // dd($total_metune);
            // dd($item);
        $tanggalAwal = date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
        $tanggalAkhir = date('Y-m-d');

        if ($request->has('tanggal_awal') && $request->tanggal_awal != "" && $request->has('tanggal_akhir') && $request->tanggal_akhir) {
            $tanggalAwal = $request->tanggal_awal;
            $tanggalAkhir = $request->tanggal_akhir;
        }
        return view('laporan_auth.cetak3',compact('total_member_untuk_admin','total_untuk_admin','total_fitness','fitness','total_akses','akses','coffee','total_coffee','protein','total_protein','total_suplement','suplement','total_drink','drink','total_food','total_member','tanggalAwal', 'tanggalAkhir','pendaftaran','date','auth','total','food','item','total_metune'));
    }

     public function cetak4(Request $request)
    {
        
       $auth = auth()->id();
        $date =  date('Y-m-d');
        $today = Carbon::today()->toDateString();
       
        $pendaftaran = DB::table('member')
            ->join('total_keseluruhan', 'total_keseluruhan.id_member', '=', 'member.id_member')
            ->select('total_keseluruhan.*', 'total_keseluruhan.total','nama')
            ->where('member.created_at', '>=', Carbon::today())
            ->where('member.role',$auth)
            ->get();

            $total_member = TotalKeseluruhan::where('role',$auth)->where('created_at', '>=', Carbon::today())->sum('total');
            $total = DB::table('total_keseluruhan')
            ->join('member', 'member.id_member', '=', 'total_keseluruhan.id_member')
            ->select('member.*')
            ->where('total_keseluruhan.role',$auth)
            ->where('total_keseluruhan.tgl_masuk',$date)
            ->groupBy('id')
            ->get();
   

        $users = DB::table('penjualan_detail')
            ->join('produk', 'penjualan_detail.id_produk', '=', 'produk.id_produk')
            ->join('penjualan', 'penjualan_detail.id_penjualan', '=', 'penjualan.id_penjualan')
            // ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah')
             ->select('produk.*', 'nama_produk','penjualan_detail.*','jumlah',DB::raw("sum(penjualan_detail.jumlah) as count"))
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            ->groupBy('penjualan_detail.id_produk')
            ->get();
    
          $p = DB::table('penjualan_detail')
            ->join('penjualan as penjualan', 'penjualan.id_penjualan', '=', 'penjualan_detail.id_penjualan')
            ->where('penjualan_detail.created_at', '>=', Carbon::today())
            ->where('id_user',$auth)
            ->sum('subtotal');

            
            // dd ($p);
            $item = PembelianGym::where('id_user',$auth)->where('created_at', '>=', Carbon::today())->get();
            $total_metune = PembelianGym::where('id_user',$auth)->where('created_at', '>=', Carbon::today())->sum('total');
            // dd($total_metune);
            // dd($item);
        $tanggalAwal = date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
        $tanggalAkhir = date('Y-m-d');

        if ($request->has('tanggal_awal') && $request->tanggal_awal != "" && $request->has('tanggal_akhir') && $request->tanggal_akhir) {
            $tanggalAwal = $request->tanggal_awal;
            $tanggalAkhir = $request->tanggal_akhir;
        }
        return view('laporan_auth.cetak4',compact('p','total_member','tanggalAwal', 'tanggalAkhir','pendaftaran','date','auth','total','users','item','total_metune'));
    }
}
