<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Penjualan;
use App\Models\Member;
use App\Models\TotalKeseluruhan;
use DB;
use Carbon\Carbon;
class UtangController extends Controller
{
    public function index()
    {
        $date = Carbon::now();
        // dd($date);
         $utang = DB::table('total_keseluruhan')
            ->join('member', 'member.id_member', '=', 'total_keseluruhan.id_member')
            ->select('total_keseluruhan.*', 'member.nama','member.catatan_utang')
            ->where('total_keseluruhan.sisa','<',0)
            ->get(); 

            // dd($utang);
        return view('utang.index',compact('date'));
    }

    public function utang_ambildata()
    {
         $utang = DB::table('total_keseluruhan')
            ->join('member', 'member.id_member', '=', 'total_keseluruhan.id_member')
            ->select('total_keseluruhan.*', 'member.nama','member.catatan_utang','member.kode_member')
            ->where('total_keseluruhan.sisa','<',0)
            ->get();
// dd($utang);
        // $utang = DB::table('penjualan')
        //     ->join('member', 'member.id_member', '=', 'penjualan.id_member')
        //     ->select('penjualan.*', 'member.nama')
        //     ->where('kembali','<',0)
        //     ->get();

        return datatables()
            ->of($utang)
            ->addIndexColumn()
            ->addColumn('kode_member', function ($utang) {
                return '<span class="label label-warning">'. $utang->kode_member .'<span>';
            })
            
            ->addColumn('aksi', function ($utang) {
                return '
                <div class="btn-group">
                    <button type="button" onclick="editForm(`'. route('utang.update', $utang->id) .'`)" class="btn btn-xs btn-info btn-flat">Bayar </i></button>
                </div>
                ';
            })
            ->rawColumns(['aksi', 'select_all','kode_member'])
            ->make(true);
    }
    public function show($id)
    {
        $utang = TotalKeseluruhan::find($id);

        return response()->json($utang);
    }

     public function update(Request $request, $id)
    {
        $penjualan = TotalKeseluruhan::find($id);
        $penjualan->sisa = $request->sisa;
        $penjualan->sisa = $request->sisa;
        $penjualan->jenis_pembayaran = $request->jenis_pembayaran;
        $penjualan->created_at = $request->created_at;
        $penjualan->update();
        return redirect()->route('utang.index')->with('tambah','Data Berhasil Ditambah');
    }
}
