<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use\App\Models\Personal;
use\App\Models\User;
use\App\Models\Checkout_pt;
use\App\Models\Checkout_staff;
use\App\Models\Checkout_instruktur;
use\App\Models\Instruktur;
use\App\Models\Member;
use Carbon\Carbon;
class CheckoutController extends Controller
{
    // PERSONAL TRAINER
    public function pt_index()
    {
        $time = Carbon::now()->toDateTimeString();
        $personal = Personal::all();
        $member = Member::all();
        return view('checkout.pt',compact('time','personal','member'));
    }
    public function pt_store(Request $request)
    {
        $checkout_pt = new Checkout_pt();
        $checkout_pt->kode_personal = $request->kode_personal;
        $checkout_pt->nama_member = $request->nama_member;
        $checkout_pt->waktu = $request->waktu;
        $checkout_pt->save();

      return redirect()->route('personal_index')->with('check out','Data Berhasil Ditambah');;
    }
// END PERSONAL TRAINER

// STAFF
    public function staff_index_check()
    {
        $time = Carbon::now()->toDateTimeString();
        $staff = User::all();
        $member = Member::all();
         return view('checkout.staff',compact('staff','time','member'));
    }
    public function staff_store(Request $request)
    {
        $checkout_staff = new Checkout_staff();
        $checkout_staff->kode_staff = $request->kode_staff;
        $checkout_staff->waktu = $request->waktu;
        $checkout_staff->nama_member = $request->nama_member;
        $checkout_staff->save();

        return redirect()->route('staff_index')->with('check out','Data Berhasil Ditambah');
    }
// END STAFF

// INSTRUKTUR
 public function instruktur_index()
    {
        $time = Carbon::now()->toDateTimeString();
        $instruktur = Instruktur::all();
        return view('checkout.instruktur',compact('time','instruktur'));
    }
    public function instruktur_store(Request $request)
    {
        $checkout_instruktur = new Checkout_instruktur();
        $checkout_instruktur->kode_instruktur = $request->kode_instruktur;
        $checkout_instruktur->waktu = $request->waktu;
        $checkout_instruktur->save();

        return redirect()->route('absen_instruktur.index')->with('check out','Berhasil Check in');
    }
// END INSTRUKTUR
    
}
