<?php

namespace App\Http\Controllers;

use App\Models\Member;
use App\Models\Marketing;
use App\Models\Setting;
use App\Models\Penjualan;
use App\Models\Paket;
use App\Models\Absen;
use App\Models\Absen_personal;
use App\Models\Instruktur;
use App\Models\Paket_personal_trainer;
use App\Models\CheckMember;
use App\Models\Personal;
use App\Models\Staff;
use App\Models\Konsultan;
use App\Models\Hadir;
use App\Models\Pegawai;
use App\Models\PT;
use App\Models\DataMember;
use App\Models\Membership;
use App\Models\TotalKeseluruhan;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;
use Redirect,Response;
use Illuminate\Support\Facades\Validator;
use PDF;
use Storage;

class MemberController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       
         $null = Penjualan::where('kembali','<',0)->get();
        // dd($null);
        $marketing = Marketing::all()->pluck('nama_marketing', 'kode_marketing');
        $paket = Paket::all();
        $ins = Instruktur::all();
        $member = Member::all();
      
       
        // dd($today);
        return view('member.index', compact('marketing','paket','ins'));
    }

    public function data()
    {
       $null = NULL;
        $hari_ini = time();
        $member = Membership::all();
        $personal = pt::all();
        // dd($member);
        $today = Carbon::now()->format('d-m-Y');
        foreach ($member as $p => $prj) {
            if ($prj->status !== 'Cancel') {
                $tgl_masuk = strtotime($prj->tgl_masuk);
                $exp_date = strtotime($prj->tgl_exp);
                if ($hari_ini < $tgl_masuk && $hari_ini < $exp_date) {
                    Membership::where('id',$prj->id_member)
                    // ->where('data_of', $prj->data_of)
                    ->update(['status_membership' => 'Aktif']);
                } else if ($hari_ini >= $tgl_masuk && $hari_ini <= $exp_date) {
                    Membership::where('id',$prj->id_member)
                    // ->where('data_of', $prj->data_of)
                    ->update(['status_membership' => 'Aktif']);
                } else if ($hari_ini > $exp_date){
                    // if (!is_null($prj->garansi)) {
                    Membership::where('id',$prj->id_member)
                    // ->where('data_of', $prj->data_of)
                    ->update(['status_membership' => 'Expired']);    
                     
                } else if ($tgl_masuk && $exp_date == null){
                    Membership::where('id',$prj->id_member)
                    ->update(['status_membership' => 'Belum Terdaftar Paket']);

                }
                             
            }              
        }
        foreach ($personal as $p => $prj2) {
            if ($prj->status !== 'Cancel') {
                $tgl_masuk2 = strtotime($prj2->tgl_masuk);
                $exp_date2 = strtotime($prj2->tgl_exp);
                if ($hari_ini < $tgl_masuk2 && $hari_ini < $exp_date2) {
                    PT::where('id_member',$prj2->id_member)
                    // ->where('data_of', $prj->data_of)
                    ->update(['status_personal_trainer' => 'Aktif']);
                } else if ($hari_ini >= $tgl_masuk2 && $hari_ini <= $exp_date2) {
                    PT::where('id_member',$prj2->id_member)
                    // ->where('data_of', $prj->data_of)
                    ->update(['status_personal_trainer' => 'Aktif']);
                } else if ($hari_ini > $exp_date2){
                    // if (!is_null($prj->garansi)) {
                    PT::where('id_member',$prj2->id_member)
                    // ->where('data_of', $prj->data_of)
                    ->update(['status_personal_trainer' => 'Expired']);    
                    
                } 
    }
}
        $member = DB::table('membership')
       ->leftjoin('data_member', 'membership.id_member', '=', 'data_member.id')
       ->leftjoin('pt', 'membership.id_member', '=', 'pt.id')
        ->select('data_member.*','membership.tgl_masuk','membership.tgl_exp','membership.status_membership','pt.status_personal_trainer')
        ->get();
// dd($member);
            return datatables()
            ->of($member)
            ->addIndexColumn()
           
            ->addColumn('kode_member', function ($member) {
                return '<span class="label label-primary">'. $member->kode_member .'<span>';
            })
            ->addColumn('status_membership', function ($member) {
                if($member->status_membership === 'Aktif')
                    return '<span class="label label-success">'. $member->status_membership .'</span>';
                elseif($member->status_membership === 'Expired')
                    return '<span class="label label-danger">'. $member->status_membership .'</span>';
            })
            ->addColumn('status_personal_trainer', function ($member) {
                if($member->status_personal_trainer === 'Aktif')
                    return '<span class="label label-success">'. $member->status_personal_trainer .'</span>';
                elseif($member->status_personal_trainer === 'Expired')
                    return '<span class="label label-danger">'. $member->status_personal_trainer .'</span>';
            })
            ->addColumn('aksi', function ($member) {
                return '
              
                        <a href="'. route('member.absen', $member->id) .'" class="btn btn-xs btn coklat btn-flat" style="color:white;">Absen</a>
                        <a href="'. route('member.edit', $member->id) .'" class="btn btn-xs btn-info btn-flat">Membership</a>
                        <a href="'. route('member.edit3', $member->id) .'" class="btn btn-xs btn-primary btn-flat">Personal Trainer</a>
                        <a href="'. route('member.edit_profil', $member->id) .'" class="btn btn-xs btn darks btn-flat" style="color:white;">Edit Profil</a>
                        <a href="'. route('member.ganti_kartu', $member->id) .'" class="btn btn-xs btn-success btn-flat" style="color:white;">Ganti Kartu</a>
                        <a href="'. route('member.detail', $member->id) .'" class="btn btn-xs btn-warning btn-flat" style="color:white;">Detail</a>
                        <button type="button" onclick="deleteData(`'. route('member.destroy', $member->id) .'`)" class="btn btn-xs btn-danger btn-flat"style="color:white;">Hapus</i></button>
                   
                ';
            })
            ->rawColumns(['aksi', 'select_all', 'kode_member','nama_instruktur','status_membership','status_personal_trainer'])
            ->make(true);
    }

    public function ambil_member_paket($id)
    {
         $detail = Member::where('id_member', $id)->get();

        return datatables()
            ->of($detail)
            ->addIndexColumn()
            ->addColumn('nama_paket', function ($detail) {
                return $detail->nama_paket;
            })
            ->rawColumns(['kode_produk'])
            ->make(true);
    }
    public function data_member($id)
    {
        $hadir = Hadir::orderBy('id', 'desc')->get();

        return datatables()
            ->of($hadir)
            ->addIndexColumn()
            ->addColumn('tanggal', function ($hadir) {
                     return tanggal_indonesia($hadir->tanggal, false);
                 })
            ->rawColumns(['aksi','tanggal'])
            ->make(true);
    }
    public function edit2($id)
    {
       
        // dd($staff2);
        $member = DataMember::find($id);
        $date = date('d-m-Y');
        $paket = Paket::orderBy('kode_paket', 'asc')->get();
        $paket_personal = Paket_personal_trainer::orderBy('kode_paket', 'asc')->get();
        $ins = Instruktur::all();
        $personal = Personal::all();
        return view('member.edit_profil', compact('paket','ins','date','paket_personal','personal','member'));
    }
   
     public function ganti_kartu($id)
    {
       
        // dd($staff2);
        $member = DataMember::find($id);
        // dd($member);
        $date = date('d-m-Y');
        $paket = Paket::orderBy('kode_paket', 'asc')->get();
        $paket_personal = Paket_personal_trainer::orderBy('kode_paket', 'asc')->get();
        $ins = Instruktur::all();
        $personal = Personal::all();
        return view('member.ganti_kartu', compact('paket','ins','date','paket_personal','personal','member'));
    }

    // public function data_absen($id)
    // {
    //     $member = Hadir::where('id_member',$id)->get();
    //     $nama = Hadir::where('id_member',$id)->pluck('nama');
    //     // dd($member);
        
    //     return view('member.data_absen',compact('member','nama'));
    // }
    public function data_absen($id)
    {
      
        $member = Hadir::where('id_member',$id);
        // dd($member);
        return datatables()
            ->of($member)
            ->addIndexColumn()
            ->addColumn('select_all', function ($member) {
                return '
                   
                ';
            })
             ->addColumn('visit', function ($member) {
                return '
                   '.$member->tanggal.' / '. $member->jam .' 
                ';
            })
           
            ->addColumn('aksi', function ($member) {
                return '
               
                ';
            })
            ->rawColumns(['aksi', 'kode_paket', 'select_all','member'])
            ->make(true);
    }

    
    public function create()
    {
        $date = date('d-m-Y');
        $paket = Paket::orderBy('kode_paket', 'asc')->get();
        $paket_personal = Paket_personal_trainer::orderBy('kode_paket', 'asc')->get();
        $ins = Instruktur::all();
        $personal = Personal::all();
        $staff = Pegawai::all();

        return view('member.create',compact('staff','paket','ins','date','paket_personal','personal'));
    }
    public function layanan_ambilData(Request $request)
    {
        if(!$request->ajax()) abort(404);
        $hasil = [];
        $spl = json_decode($request->layanan_id);
        $layanan_id = Paket::where('nama_paket', $spl)->get();
        $hasil = $layanan_id;
        return Response::json($hasil);
        // dd($layanan_id);
    }
    public function layanan_ambilData2(Request $request)
    {
        if(!$request->ajax()) abort(404);
        $hasil = [];
        $spl = json_decode($request->iseng);
        $iseng = Paket_personal_trainer::where('nama_paket', $spl)->get();
        $hasil = $iseng;
        return Response::json($hasil);
        // dd($iseng);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
   

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store_absen2(Request $request)
    {
        $member = Absen_personal::latest()->first() ?? new Absen_personal();
       
        $member = Absen_personal::create($request->all());
       
// dd($member->all());
       return response()->json('Data berhasil disimpan', 200);
    }
    public function store(Request $request)
    {
        request()->validate([
           'kode_member' => 'required',
           'nama' => 'required',
           'ttl' => 'required',
           'alamat' => 'required',
           'telepon' => 'required',
           'telepon_darurat' => 'required',
           'no_ktp' => 'required',
           'gender' => 'required',
           'email' => 'required',
           'alamat_kantor' => 'required',
          

        ],
        [
        'kode_member.required' => 'Kode member tidak boleh kosong',
         'nama.required' => 'Nama member tidak boleh kosong',
         'ttl.required' => 'Tempat tanggal lahir tidak boleh kosong',
         'alamat.required' => 'Alamat tidak boleh kosong',
         'telepon.required' => 'Telepon tidak boleh kosong',
         'telepon_darurat.required' => 'Telepon darurat tidak boleh kosong',
         'no_ktp.required' => 'Nomer KTP tidak boleh kosong',
         'gender.required' => 'Gender tidak boleh kosong',
         'email.required' => 'Email tidak boleh kosong',
         'alamat_kantor.required' => 'Alamat kantor tidak boleh kosong',
        //  'nama_paket.required' => 'Nama paket tidak boleh kosong',
        //  'harga.required' => 'Harga tidak boleh kosong',
        //  'tgl_masuk.required' => 'Tanggal masuk tidak boleh kosong',
        //  'exp_date.required' => 'Tanggal Expired  tidak boleh kosong',
        //  'nama_paket2.required' => 'Nama paket tidak boleh kosong',
        //  'harga2.required' => 'Harga tidak boleh kosong',
        //  'id_instruktur.required' => 'Personal trainer tidak boleh kosong',
        //  'tgl_masuk2.required' => 'Tanggal masuk tidak boleh kosong',
        //  'exp_date2.required' => 'Tanggal Expired tidak boleh kosong',
        //  'biaya_admin.required' => 'Biaya admin tidak boleh kosong',
        //  'biaya_lainnya.required' => 'Biaya lainnya tidak boleh kosong',
        //  'total.required' => 'Total tidak boleh kosong',
        //  'tanggal_bayar2.required' => 'Tanggal Pembayaran tidak boleh kosong',
        //  'jenis_pembayaran_pribadi.required' => 'Jenis Pembayaran tidak boleh kosong',
        //  'harus_bayar.required' => 'Harus bayar tidak boleh kosong',
        //  'sisa.required' => 'Sisa tidak boleh kosong',
        //  'nama_staff.required' => 'Nama Staff tidak boleh kosong',
        ]);
       
         
        $img = $request->foto;
        $folderPath = "files/";
    
        $image_parts = explode(";base64,", $img);
        $image_type_aux = explode("image/", $image_parts[0]);
        $image_type = $image_type_aux[1];
    
        $image_base64 = base64_decode($image_parts[1]);
        $fileName = uniqid() . '.png';
    
        $file = $folderPath . $fileName;
        Storage::put($file, $image_base64);

        $member = new DataMember();
        $member->id = $request->id;
        $member->nama = $request->nama;
        $member->kode_member = $request->kode_member;
        $member->status = $request->status;
        $member->ttl = $request->ttl;
        $member->alamat = $request->alamat;
        $member->telepon = $request->telepon;
        $member->telepon_darurat = $request->telepon_darurat;
        $member->no_ktp = $request->no_ktp;
        $member->gender = $request->gender;
        $member->sosmed = $request->sosmed;
        $member->email = $request->email;
        $member->alamat_kantor = $request->alamat_kantor;
        $member->role = $request->role;
        $member->foto = $fileName;
        $member->save();


        $membership = new Membership();
        $membership->id_member = $member->id;
        $membership->id_paket = '-';
        $membership->harga = '0';
        $membership->tgl_masuk = '-';
        $membership->tgl_exp = '-';
        $membership->biaya_admin = '0';
        $membership->biaya_lainnya = '0';
        $membership->total = '0';
        $membership->save();

        $pt = new PT();
        $pt->id_member = $member->id;
        $pt->id_paket = '-';
        $pt->harga = '0';
        $pt->tgl_masuk = '-';
        $pt->tgl_exp = '-';
        $pt->biaya_admin = '0';
        $pt->biaya_lainnya = '0';
        $pt->total = '0';
        $pt->save();
        
        // $total =  new TotalKeseluruhan();
        // $total->id_member = $member->id;
        // $total->total = ;
        // $total->role = $request->role;
        // $total->tgl_masuk = $request->tgl_masuk;
        // $total->status = $request->status;
        // $total->harus_bayar = $request->harus_bayar;
        // $total->sisa = $request->sisa;
        // $total->catatan_utang = $request->catatan_utang;
        // $total->nama_staff =  auth()->user()->name;
        // $request['nomer_absen'] = 'P'. tambah_nol_didepan((int)$total->id_member+1, 6);
        // $total->save();



        return redirect()->route('member.index')->with('tambah','Data Berhasil Ditambah');
    }
    public function store_absen(Request $request)
    {
        $member = Absen::latest()->first() ?? new Absen();
       
        $member = Absen::create($request->all());
       
// dd($member->all());
       return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $member = DB::table('data_member')
        ->leftjoin('membership', 'data_member.id', '=', 'membership.id')
        ->leftjoin('pt', 'data_member.id', '=', 'pt.id')
        ->leftjoin('paket_personal_trainer', 'pt.id_paket', '=', 'paket_personal_trainer.id')
        ->leftjoin('paket', 'membership.id_paket', '=', 'paket.id')
        ->leftjoin('personal_trainer', 'pt.id_personal', '=', 'personal_trainer.id_personal')
        ->leftjoin('konsultan', 'membership.id_konsultan', '=', 'konsultan.id')
        ->select('membership.*','membership.tgl_masuk','membership.tgl_exp','data_member.*','paket_personal_trainer.nama_paket as nama_paket_personal_trainer','paket.nama_paket','paket_personal_trainer.harga as harga_personal_trainer','personal_trainer.nama_personal','membership.biaya_lainnya as membership_biaya_lainnya','membership.biaya_admin as membership_biaya_admin','membership.total as membership_total','pt.biaya_lainnya as pt_biaya_lainnya','pt.biaya_admin as pt_biaya_admin','pt.total as pt_total','konsultan.nama as nama_konsultan','membership.tgl_masuk as tgl_masuk_membership','membership.tgl_exp as tgl_exp_membership','pt.tgl_masuk as tgl_masuk_pt','pt.tgl_exp as tgl_exp_pt','membership.jenis_pembayaran_pribadi as jenis_bayar_membership','pt.jenis_pembayaran_pribadi as jenis_bayar_pt','paket.nama_paket as nama_paket_membership','pt.id_paket as paket_pt','pt.harga as harga_pt','konsultan.nama as nama_konsultan','membership.foto as foto_membership','pt.foto as foto_personal','data_member.foto as foto_member')
        ->where('membership.id',$id)
        ->first();
        // dd($member);
        return view('member.detail', compact('member'));
    }
    public function data_absen2($id)
    {
      
        $member = Absen_personal::where('id_member',$id);

        return datatables()
            ->of($member)
            ->addIndexColumn()
            ->addColumn('select_all', function ($member) {
                return '
                   
                ';
            })
           
            ->addColumn('aksi', function ($member) {
                return '
               
                ';
            })
            ->rawColumns(['aksi', 'kode_paket', 'select_all'])
            ->make(true);
    }
     public function absen($id)
    {
        $member = DataMember::find($id);
    //  dd($member);
        return view('member.absen', compact('member'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $meme = Membership::all();
        $member = Membership::find($id);
        // dd($post);
        // $member = DB::table('membership')
        // ->join('data_member', 'membership.id_member', '=', 'data_member.id')
        // ->select('data_member.*','membership.tgl_masuk','membership.tgl_exp')
        // ->where('membership.id',$id)
        // ->first();
        $konsultan = Konsultan::all();
        // dd($member);
        $date = date('d-m-Y');
        $paket = Paket::orderBy('kode_paket', 'asc')->get();
        $paket_personal = Paket_personal_trainer::orderBy('kode_paket', 'asc')->get();
        $ins = Instruktur::all();
        $personal = Personal::all();
        $staff = Pegawai::all();
        return view('member.edit', compact('konsultan','staff','paket','ins','date','paket_personal','personal','member'));
    }
    public function edit3($id)
    {
        $member = PT::find($id);
       
        $konsultan = Konsultan::all();
        // dd($member);
        $date = date('d-m-Y');
        $paket = Paket::orderBy('kode_paket', 'asc')->get();
        $paket_personal = Paket_personal_trainer::orderBy('kode_paket', 'asc')->get();
        $ins = Instruktur::all();
        $personal = Personal::all();
        $staff = Pegawai::all();
        return view('member.edit_pt', compact('konsultan','staff','paket','ins','date','paket_personal','personal','member'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd($request->all());
        $img = $request->foto;
        $folderPath = "foto membership/";
    
        $image_parts = explode(";base64,", $img);
        $image_type_aux = explode("image/", $image_parts[0]);
        $image_type = $image_type_aux[1];
    
        $image_base64 = base64_decode($image_parts[1]);
        $fileName = uniqid() . '.png';
    
        $file = $folderPath . $fileName;
        Storage::put($file, $image_base64);
        $post = Membership::find($id);
        $post->update([
            'tgl_masuk' => $request->tgl_masuk,
            'tgl_exp' => $request->tgl_exp,
            'id_paket' => $request->id_paket,
            'harga' => $request->harga,
            'biaya_lainnya' => $request->biaya_lainnya,
            'biaya_admin' => $request->biaya_admin,
            'total' => $request->total,
            'status' => $request->status,
            'jenis_pembayaran_pribadi' => $request->jenis_pembayaran_pribadi,
            'nama_bank' => $request->nama_bank,
            'id_konsultan' => $request->id_konsultan,
            'foto' => $fileName,
            
        ]);

        $total =  new TotalKeseluruhan();
        $total->id_member = $request->id_member;
        $total->total = $request->total;
        $total->status = $request->status;
        $total->nama_staff =  auth()->user()->name;
        $total->save();
       

      return redirect()->route('member.index')->with('edit','Data Berhasil Perpanjang');
    }
    public function updated_personal(Request $request, $id)
    {
        $img = $request->foto;
        $folderPath = "foto personal/";
    
        $image_parts = explode(";base64,", $img);
        $image_type_aux = explode("image/", $image_parts[0]);
        $image_type = $image_type_aux[1];
    
        $image_base64 = base64_decode($image_parts[1]);
        $fileName = uniqid() . '.png';
    
        $file = $folderPath . $fileName;
        Storage::put($file, $image_base64);
        $post = PT::find($id);
        $post->update([
            'tgl_masuk' => $request->tgl_masuk,
            'tgl_exp' => $request->tgl_exp,
            'id_paket' => $request->id_paket,
            'harga' => $request->harga,
            'biaya_lainnya' => $request->biaya_lainnya,
            'biaya_admin' => $request->biaya_admin,
            'total' => $request->total,
            'status' => $request->status,
            'jenis_pembayaran_pribadi' => $request->jenis_pembayaran_pribadi,
            'nama_bank' => $request->nama_bank,
            'foto' => $fileName,
            'id_personal' => $request->id_personal,
            
        ]);
        $total =  new TotalKeseluruhan();
        $total->id_member = $request->id_member;
        $total->total = $request->total;
        $total->status = $request->status;
        $total->nama_staff =  auth()->user()->name;
        $total->save();
       

      return redirect()->route('member.index')->with('edit','Data Berhasil Perpanjang');
    }
    public function updated_detail(Request $request, $id)
    {
         
        $member = Member::find($id);
        $member->catatan = $request->catatan;
        $member->update();
        
      return redirect()->route('member.detail', $member->id_member)->with('edit','Data Berhasil Perpanjang');
    }
    public function updated_profil(Request $request, $id)
    {
        $member = DataMember::find($id);
       
        $member->kode_member = $request->kode_member;
        $member->nama = $request->nama;
        $member->ttl = $request->ttl;
        $member->no_ktp = $request->no_ktp;
        $member->gender = $request->gender;
        $member->alamat = $request->alamat;
        $member->alamat_kantor = $request->alamat_kantor;
        $member->sosmed = $request->sosmed;
        $member->telepon = $request->telepon;
        $member->telepon_darurat = $request->telepon_darurat;
        $member->email = $request->email;
        $member->update();

        // $total =  new TotalKeseluruhan();
        // $total->id_member = $request->id_member;
        // $total->total = $request->total;
        // $total->role = $request->role;
        // $total->tgl_masuk = $request->tgl_masuk;
        // $total->status = $request->status;
        // $total->harus_bayar = $request->harus_bayar;
        // $total->sisa = $request->sisa;
        // $total->catatan_utang = $request->catatan_utang;
        // $total->nama_staff =  auth()->user()->name;
        // $request['nomer_absen'] = 'P'. tambah_nol_didepan((int)$total->id_member +1,);
        // $total->save();
        return redirect()->route('member.index')->with('tambah','Data Berhasil Ditambah');
    }
     public function updated_kartu(Request $request, $id)
    {
        
        $member = DataMember::find($id);
    //    dd($request->all());
        $member->kode_member = $request->kode_member;

        $member->update();

        $total =  new TotalKeseluruhan();
        $total->id_member = $request->id_member;
        $total->total = $request->total;
        $total->status = $request->status;
        $total->nama_staff =  auth()->user()->name;
        $total->save();
        return redirect()->route('member.index')->with('tambah','Data Berhasil Ditambah');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $member = DataMember::find($id);
        $member->delete();

        $member2 = Membership::find($id);
        $member2->delete();
        
        $member3 = PT::find($id);
        $member3->delete();

        return response(null, 204);
    }

    public function cetak2($id)
    {
          $member = Member::find($id);
        return view('member.cetak2', compact('member'));
    }
    public function cetakMember(Request $request)
    {
        $datamember = collect(array());
        foreach ($request->id_member as $id) {
            $member = Member::find($id);
            $datamember[] = $member;
        }

        $datamember = $datamember->chunk(2);
        $setting    = Setting::first();

        $no  = 1;
        $pdf = PDF::loadView('member.cetak', compact('datamember', 'no', 'setting'));
        $pdf->setPaper(array(0, 0, 566.93, 850.39), 'potrait');
        return $pdf->stream('member.pdf');
    }

     public function cetak_pdf($id)
    {
    	$member = Member::find($id);
        
    	$pdf = PDF::loadview('member.cetak2',['member'=>$member]);
    	return $pdf->download('laporan-member-pdf');
    }
}
