<?php

namespace App\Http\Controllers;

use App\Models\Service;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    public function index()
    {
        return view('service.index');
    }

    public function data()
    {
        $service = Service::orderBy('id', 'desc')->get();

        return datatables()
            ->of($service)
            ->addIndexColumn()
            ->addColumn('kode_service', function ($service) {
                return '<span class="label label-success">'. $service->kode_service .'</span>';
            })
            ->addColumn('aksi', function ($service) {
                return '
                <div class="btn-group">
                    <button type="button" onclick="editForm(`'. route('service.update', $service->id) .'`)" class="btn btn-xs btn-info btn-flat"><i class="fa fa-pencil"></i></button>
                    <button type="button" onclick="deleteData(`'. route('service.destroy', $service->id) .'`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
                </div>
                ';
            })
            ->rawColumns(['aksi', 'kode_service', 'select_all'])
            ->make(true);
    }

    public function store(Request $request)
    {
        $service = Service::latest()->first() ?? new Service();
        $request['kode_service'] = 'S'. tambah_nol_didepan((int)$service->id +1, 6);

        $service = Service::create($request->all());
    }

    public function update(Request $request, $id)
    {
        $service = Service::find($id)->update($request->all());

            return response()->json('Data berhasil disimpan', 200);
    }
    public function show($id)
    {
        $service = Service::find($id);

        return response()->json($service);
    }

}
