<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Target;

class TargetController extends Controller
{
    public function index()
    {
        $bulan = date('M Y');
        $date = date('Y-m-d');
        // dd($bulan);
        return view('target.index', compact('bulan','date'));
    }

    public function data()
    {
        $target = Target::orderBy('id_target', 'desc')->get();

        return datatables()
            ->of($target)
            ->addIndexColumn()
           
            ->addColumn('aksi', function ($target) {
                return '
                <div class="btn-group">
                    <button type="button" onclick="editForm(`'. route('target.update', $target->id_target) .'`)" class="btn btn-xs btn-info btn-flat"><i class="fa fa-pencil"></i></button>
                    <button type="button" onclick="deleteData(`'. route('target.destroy', $target->id_target) .'`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
                </div>
                ';
            })
            ->addColumn('target_bulan', function ($target) {
                return format_uang($target->target_bulan);
            })
            ->addColumn('tanggal', function ($target) {
                return bulan($target->tanggal, false);
            })
            ->rawColumns(['aksi','tanggal_nih'])
            ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // $validatedData = $request->validate([
        //     'tanggal' => [ 'unique:target'],
          
        // ]);
        $h = preg_replace('/[^0-9]/', '', $request->get('target_bulan'));
        $target = new Target();
        $target->tanggal = $request->tanggal;
        $target->target_bulan = $h;

       
       $target->save();

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $target = Target::find($id);

        return response()->json($target);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $harga_jual = preg_replace('/[^0-9]/', '', $request->get('target_bulan'));
        $target = Target::find($id);
        
        $target->tanggal = $request->tanggal;
        $target->target_bulan = $harga_jual;

        $target->update();

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $target = Target::find($id)->delete();

        return response(null, 204);
    }
}

