@extends('layouts.master')

@section('title')
    Daftar Afiliasi
@endsection

@section('breadcrumb')
    @parent
    <li class="active">Daftar Afiliasi</li>
@endsection

@section('content')
<div class="row">
    <div class="col-lg-12">
        <div class="box">
            <div class="box-header with-border">
                <div class="btn-group">
                    <!-- <button onclick="addForm('{{ route('produk.store') }}')" class="btn btn-success btn-xs btn-flat"><i class="fa fa-plus-circle"></i> Tambah</button> -->
                    <!-- <button onclick="cetakBarcode('{{ route('produk.cetak_barcode') }}')" class="btn btn-info btn-xs btn-flat"><i class="fa fa-barcode"></i> Cetak Barcode</button> -->
                </div>
            </div>
            <div class="box-body table-responsive">
                <form action="" method="post" class="form-produk">
                    @csrf
                    <table class="table table-stiped table-bordered" id="table_1">
                        <thead>
                            <th width="5%">No</th>
                            <th>Tanggal</th>
                            <th>Nama</th>
                            <th>Nama Paket Personal</th>
                            <th>Harga</th>
                        </thead>
                        <tbody>
                        @foreach ($afiliansi as $key => $item)
                            <tr>
                                <td width="5%">{{ $key+1 }}</td>
                                <td>{{tanggal_indonesia($item->tanggal_personal)}}</td>
                                <td>{{ $item->nama_personal }}</td>
                                <td>{{ $item->id_paket }}</td>
                                <td>@currency ($item->harga )</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
    let table;
        table = $('#table_1').DataTable();

</script>
@endpush